package gov.va.med.mhv.usermgmt.util.mvi;

import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlOptions;

import gov.va.med.mhv.mvi.xsd.AD;
import gov.va.med.mhv.mvi.xsd.ActClassControlAct;
import gov.va.med.mhv.mvi.xsd.CD;
import gov.va.med.mhv.mvi.xsd.CE;
import gov.va.med.mhv.mvi.xsd.CS;
import gov.va.med.mhv.mvi.xsd.CommunicationFunctionType;
import gov.va.med.mhv.mvi.xsd.EN;
import gov.va.med.mhv.mvi.xsd.EntityClassDevice;
import gov.va.med.mhv.mvi.xsd.II;
import gov.va.med.mhv.mvi.xsd.INT;
import gov.va.med.mhv.mvi.xsd.IVLTS;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Device;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Receiver;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Sender;
import gov.va.med.mhv.mvi.xsd.PRPAIN201301UV02MFMIMT700701UV01ControlActProcess;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02QUQIMT021001UV01ControlActProcess;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02LivingSubjectAdministrativeGender;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02LivingSubjectBirthTime;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02LivingSubjectId;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02LivingSubjectName;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02ParameterList;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02PatientAddress;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02QueryByParameter;
import gov.va.med.mhv.mvi.xsd.TEL;
import gov.va.med.mhv.mvi.xsd.TS;
import gov.va.med.mhv.mvi.xsd.XActMoodIntentEvent;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document.PRPAIN201305UV02;
import gov.va.med.mhv.usermgmt.enumeration.CountryEnumeration;
import gov.va.med.mhv.usermgmt.enumeration.GenderEnumeration;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;


/**
 * @author vhaiswkhanm
 *
 */
public class CreateMVISearchReqUSAA {

	private static final Log LOG = LogFactory.getLog(CreateMVIPatientSearchRequest.class);

	/**
	 * @param First Name
	 * @param Middle Name
	 * @param Last Name
	 * @param Date of Birth
	 * @param gender
	 * @param SSN
	 * @return
	 */
	public static Object createPatientSearchXMLRequest(String fName, String mName, String lName, String DOB, String gender, String SSN) {
		// Configuration Properties
		MviProperties properties = MviProperties.getInstance();

		if(properties.getIsMviMockSearchEnabled())
			return createMockPatientSearchXMLRequest();

		PRPAIN201305UV02Document root1305Doc = PRPAIN201305UV02Document.Factory.newInstance();
		PRPAIN201305UV02 root1305Req = root1305Doc.addNewPRPAIN201305UV02();

		root1305Req.setITSVersion(MviConstants.MVI_XML_REQ_ITS_VERSION);
		/*
		<urn:id root="2.16.840.1.113883.3.933" extension="MCID-12345"/>
    		<urn:creationTime value="20070428150301 "/>
    		<urn:interactionId root="2.16.840.1.113883.1.6"
		 */
		II rootId = root1305Req.addNewId();
		rootId.setRoot(properties.getMviRootId());

		String mcidExtension = MviUtil.getMCIDExtension();
		long mcidUniqValue = MviUtil.getUniqueId();

		rootId.setExtension(mcidExtension + String.valueOf(mcidUniqValue) );

		TS creationTime = root1305Req.addNewCreationTime();
		creationTime.setValue(MviUtil.getCreationTime());

		II interactionId = root1305Req.addNewInteractionId();
		interactionId.setRoot(properties.getMviInteractionId()); interactionId.setExtension(MviConstants.MVI_INTERACTION_SEARCH_TYPE);
		/*
		    <urn:processingCode code="T "/>
		    <urn:processingModeCode code="R "/>
		    <urn:acceptAckCode code="AL "/>
		 */
		CS processingCode = root1305Req.addNewProcessingCode();
		if(properties.getMviEnvType().equalsIgnoreCase("prod"))
			processingCode.setCode(MviConstants.MVI_PROCESSING_PROD_CODE);
		else
			processingCode.setCode(MviConstants.MVI_PROCESSING_NONPROD_CODE);
		CS processingModeCode = root1305Req.addNewProcessingModeCode();
		processingModeCode.setCode(MviConstants.MVI_PROCESSING_MODE_CODE);

		CS acceptAckCode = root1305Req.addNewAcceptAckCode();
		acceptAckCode.setCode(MviConstants.MVI_ACCEPT_ACK_CODE);
		/*
		<urn:receiver typeCode="RCV">
	        <urn:device classCode="DEV" determinerCode="INSTANCE">
	            <urn:id root="2.16.840.1.113883.4.349 "/>
	            <urn:telecom value="https://example.org/PatientFeed"/>
	        </urn:device>
    	</urn:receiver>
		 */
		MCCIMT000100UV01Receiver receiver = root1305Req.addNewReceiver();
		receiver.setTypeCode(CommunicationFunctionType.RCV);
		MCCIMT000100UV01Device device = receiver.addNewDevice();
		device.setClassCode(EntityClassDevice.DEV);
		device.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II deviceId = device.addNewId();
		deviceId.setRoot(properties.getVaOidValue());
		//TEL deviceTelecom = device.addNewTelecom();
		//deviceTelecom.setValue("http://servicelocation/PDQuery");

		/*
	    <urn:sender typeCode="SND">
	        <urn:device classCode="DEV" determinerCode="INSTANCE">
	            <urn:id extension="200MH " root="2.16.840.1.113883.3.933"/>
	        </urn:device>
	    </urn:sender>
 		 */
		MCCIMT000100UV01Sender sender = root1305Req.addNewSender();
		sender.setTypeCode(CommunicationFunctionType.SND);
		MCCIMT000100UV01Device senderDevice = sender.addNewDevice();
		senderDevice.setClassCode(EntityClassDevice.DEV);
		senderDevice.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II senderId = senderDevice.addNewId();
		senderId.setExtension(properties.getMviReceivingFacilityId());
		senderId.setRoot(properties.getMviRootId());

		/*
	    <urn:controlActProcess classCode="CACT" moodCode="EVN">
        <urn:code codeSystem="2.16.840.1.113883.1.6" code="PRPA_TE201305UV02"/>
        <urn:queryByParameter>

		 */
		PRPAIN201305UV02QUQIMT021001UV01ControlActProcess controlActProcess = root1305Req.addNewControlActProcess();
		root1305Req.setControlActProcess(controlActProcess);
		controlActProcess.setClassCode(ActClassControlAct.CACT);
		controlActProcess.setMoodCode(XActMoodIntentEvent.EVN);
		CD controlCode = controlActProcess.addNewCode();
		controlCode.setCodeSystem(properties.getMviInteractionId());controlCode.setCode(MviConstants.MVI_SEARCH_CONTROL_CODE);

		/*
		<urn:queryId root="2.16.840.1.113883.3.933" extension="18204"/>
        <urn:statusCode code="new"/>
        <urn:initialQuantity value="1"/>
		 */
		PRPAMT201306UV02QueryByParameter controlQueryParameter = controlActProcess.addNewQueryByParameter();
		II controlQueryId = controlQueryParameter.addNewQueryId();
		controlQueryId.setRoot(properties.getMviRootId()); controlQueryId.setExtension(String.valueOf(mcidUniqValue));

		CS controlStatusCode = controlQueryParameter.addNewStatusCode();
		controlStatusCode.setCode(MviConstants.MVI_NEW_STATUS_CODE);
		INT initialQuantity = controlQueryParameter.addNewInitialQuantity();
		initialQuantity.setValue(new BigInteger("1"));
		CS modifyCode = controlQueryParameter.addNewModifyCode();
		modifyCode.setCode("MVI.COMP1");
		PRPAMT201306UV02ParameterList parameterList = controlQueryParameter.addNewParameterList();

		/*
		<livingSubjectAdministrativeGender>
        <value code="M" />
        <semanticsText>LivingSubject.administrativeGender</semanticsText>
        </livingSubjejctAdministrativeGender>
		*/
		PRPAMT201306UV02LivingSubjectAdministrativeGender adminGender = parameterList.addNewLivingSubjectAdministrativeGender();
		CE genderCode = adminGender.addNewValue();
		if(gender.equalsIgnoreCase(GenderEnumeration.MALE))
			genderCode.setCode(MviConstants.MVI_MALE_GENDER_CODE);
		else if(gender.equalsIgnoreCase(GenderEnumeration.FEMALE))
			genderCode.setCode(MviConstants.MVI_FEMALE_GENDER_CODE);
		adminGender.setSemanticsText(MviConstants.MVI_LIVING_SUB_ADMIN_GENDER);
		/*
        <livingSubjectBirthTime>
        	<value value="19550512" />
        	<semanticsText>LivingSubject..birthTime</semanticsText>
        </livingSubjectBirthTime>
		*/
		PRPAMT201306UV02LivingSubjectBirthTime livingSubjectBirthTime = parameterList.addNewLivingSubjectBirthTime();
		IVLTS birthTimeValue = livingSubjectBirthTime.addNewValue();
		SimpleDateFormat dateformatYYYYMMDD = new SimpleDateFormat("yyyyMMdd");
//		StringBuilder nowYYYYMMDD = new StringBuilder( dateformatYYYYMMDD.format(DOB));
//		birthTimeValue.setValue(nowYYYYMMDD.toString());
//		birthTimeValue.setValue(DOB);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Date date = null;
		try {
			date = sdf.parse(DOB.substring(0, 10));
		} catch (ParseException e) {
			if(LOG.isErrorEnabled()){
				LOG.error("Not able to parse date for the user:: " + fName + " " + lName + ", birthdate: " + DOB);
			}
		}
		StringBuilder nowYYYYMMDD = new StringBuilder( dateformatYYYYMMDD.format(date));
		birthTimeValue.setValue(nowYYYYMMDD.toString());
//		birthTimeValue.setValue(date.toString());
		livingSubjectBirthTime.setSemanticsText(MviConstants.MVI_LIVING_SUB_BIRTHTIME);
        /*
		<livingSubjectId>
        	<value root="2.16.840.1.113883.4.1" extension="111223333" />
        </livingSubjectId>
		*/
		PRPAMT201306UV02LivingSubjectId livingSubjectId = parameterList.addNewLivingSubjectId();
		II subjectId = livingSubjectId.addNewValue();
		subjectId.setRoot(properties.getMviUsssaIdentifierId());
		String formattedSSN = SSN.replaceAll("[\\s\\-()]", "");
		subjectId.setExtension(formattedSSN);
		//subjectId.setExtension("014193804");
		livingSubjectId.setSemanticsText(MviConstants.MVI_LIVING_SUB_SSN_ID);
		/*
		<livingSubjectName>
        <value use="L">
            <given>Clark</given>
            <given>Micheal</given>
            <prefix>Dr.</prefix>
            <suffix>IV</suffix>
            <family>Kent</family>
        </value>
        <semanticsText>LivingSubject.name</semanticsText>
    	</livingSubjectName>
		*/
		PRPAMT201306UV02LivingSubjectName livingSubjectName = parameterList.addNewLivingSubjectName();
		EN subjectValue = livingSubjectName.addNewValue();
		List nameTypelist = new ArrayList(); nameTypelist.add("L");
		subjectValue.setUse(nameTypelist);
		String givenName1 = fName;
		String[] givenNameArray;
		if(mName != null) {
			String givenName2 = mName;
			givenNameArray = new String[] {givenName1, givenName2};
		}
		else
			givenNameArray = new String[] {givenName1};
		subjectValue.setGivenArray(givenNameArray);
//		if(userProfile.getTitle() != null) {
//			String prefix=userProfile.getTitle().getName(); String[] prefixArray = new String[] {prefix};
//			subjectValue.setPrefixArray(prefixArray);
//		}
//		if(userProfile.getSuffix() != null) {
//			String suffix=userProfile.getSuffix().getName(); String[] suffixArray = new String[] {suffix};
//			subjectValue.setSuffixArray(suffixArray);
//		}

		String familyName=lName; String[] familyNameArray = new String[] {familyName};
		subjectValue.setFamilyArray(familyNameArray);
		livingSubjectName.setSemanticsText(MviConstants.MVI_LIVING_SUB_NAME);
        /*
		<patientAddress>
        <value use="PHYS">
            <streetAddressLine>Street1</streetAddressLine>
            <streetAddressLine>Street2</streetAddressLine>
            <streetAddressLine>Street3</streetAddressLine>
            <streetAddressLine>Street4</streetAddressLine>
            <city>Miami</city>
            <state>FL</state>
            <postalCode>33123</postalCode>
            <country>USA</country>
        </value>
        <semanticsText />
    	</patientAddress>
		*/

		//Printing the Request XML For fine output
		XmlOptions options = new XmlOptions();
        options.put( XmlOptions.LOAD_LINE_NUMBERS );
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        if(LOG.isDebugEnabled())
        	LOG.debug("\n" +root1305Doc.xmlText(options));

        // TEST the validity of an XML
        ArrayList validationErrors = new ArrayList();
        options.setErrorListener(validationErrors);

        boolean valid =root1305Doc.validate(options);
        if(valid){
        	if(LOG.isDebugEnabled())
				LOG.debug("Its valid 1305 Search Request xml");
        }
        else{
        		LOG.error("Not a valid 1305 Search xml ");
          Iterator itr = validationErrors.iterator();
          //CR1964 -        - Make sure that the code doesn't go into the infinite loop.
    	  if(LOG.isDebugEnabled()) {
	          while(itr.hasNext()){
	  			LOG.debug(itr.next().toString());
	          }
    	  }
        }
      return root1305Doc.xmlText();

	}

	public static Object createMockPatientSearchXMLRequest() {

		PRPAIN201305UV02Document root1305Doc = PRPAIN201305UV02Document.Factory.newInstance();
		PRPAIN201305UV02 root1305Req = root1305Doc.addNewPRPAIN201305UV02();

		root1305Req.setITSVersion("XML_1.0");

		II rootId = root1305Req.addNewId();
		rootId.setRoot("2.16.840.1.113883.3.933");
		rootId.setExtension("MCID-12345");

		TS creationTime = root1305Req.addNewCreationTime();
		creationTime.setValue("20070428150301");

		II interactionId = root1305Req.addNewInteractionId();
		interactionId.setRoot("2.16.840.1.113883.1.6"); interactionId.setExtension("PRPA_IN201305UV02");

		CS processingCode = root1305Req.addNewProcessingCode();
		processingCode.setCode("T");
		CS processingModeCode = root1305Req.addNewProcessingModeCode();
		processingModeCode.setCode("T");

		CS acceptAckCode = root1305Req.addNewAcceptAckCode();
		acceptAckCode.setCode("AL");

		MCCIMT000100UV01Receiver receiver = root1305Req.addNewReceiver();
		receiver.setTypeCode(CommunicationFunctionType.RCV);
		MCCIMT000100UV01Device device = receiver.addNewDevice();
		device.setClassCode(EntityClassDevice.DEV);
		device.setDeterminerCode("INSTANCE");
		II deviceId = device.addNewId();
		deviceId.setRoot("2.16.840.1.113883.4.349");
		//TEL deviceTelecom = device.addNewTelecom();
		//deviceTelecom.setValue("http://servicelocation/PDQuery");

		MCCIMT000100UV01Sender sender = root1305Req.addNewSender();
		sender.setTypeCode(CommunicationFunctionType.SND);
		MCCIMT000100UV01Device senderDevice = sender.addNewDevice();
		senderDevice.setClassCode(EntityClassDevice.DEV);
		senderDevice.setDeterminerCode("INSTANCE");
		II senderId = senderDevice.addNewId();
		senderId.setExtension("200MH");
		senderId.setRoot("2.16.840.1.113883.3.933");

		PRPAIN201305UV02QUQIMT021001UV01ControlActProcess controlActProcess = root1305Req.addNewControlActProcess();
		root1305Req.setControlActProcess(controlActProcess);
		controlActProcess.setClassCode(ActClassControlAct.CACT);
		controlActProcess.setMoodCode(XActMoodIntentEvent.EVN);
		CD controlCode = controlActProcess.addNewCode();
		controlCode.setCodeSystem("2.16.840.1.113883.1.6");controlCode.setCode("PRPA_TE201305UV02");

		PRPAMT201306UV02QueryByParameter controlQueryParameter = controlActProcess.addNewQueryByParameter();
		II controlQueryId = controlQueryParameter.addNewQueryId();
		controlQueryId.setRoot("2.16.840.1.113883.3.933"); controlQueryId.setExtension("18204");

		CS controlStatusCode = controlQueryParameter.addNewStatusCode();
		controlStatusCode.setCode("new");
		INT initialQuantity = controlQueryParameter.addNewInitialQuantity();
		initialQuantity.setValue(new BigInteger("1"));
		CS modifyCode = controlQueryParameter.addNewModifyCode();
		modifyCode.setCode("MVI.COMP1");
		PRPAMT201306UV02ParameterList parameterList = controlQueryParameter.addNewParameterList();

		/*
		<livingSubjectAdministrativeGender>
        <value code="M" />
        <semanticsText>LivingSubject.administrativeGender</semanticsText>
        </livingSubjejctAdministrativeGender>
		*/
		PRPAMT201306UV02LivingSubjectAdministrativeGender adminGender = parameterList.addNewLivingSubjectAdministrativeGender();
		CE genderCode = adminGender.addNewValue();
		genderCode.setCode("M");
		adminGender.setSemanticsText("LivingSubject.administrativeGender");
		/*
        <livingSubjectBirthTime>
        	<value value="19550512" />
        	<semanticsText>LivingSubject..birthTime</semanticsText>
        </livingSubjectBirthTime>
		*/
		PRPAMT201306UV02LivingSubjectBirthTime livingSubjectBirthTime = parameterList.addNewLivingSubjectBirthTime();
		IVLTS birthTimeValue = livingSubjectBirthTime.addNewValue();
		birthTimeValue.setValue("19190811");
		livingSubjectBirthTime.setSemanticsText("LivingSubject.birthTime");
        /*
		<livingSubjectId>
        	<value root="2.16.840.1.113883.4.1" extension="111223333" />
        </livingSubjectId>
		*/
		PRPAMT201306UV02LivingSubjectId livingSubjectId = parameterList.addNewLivingSubjectId();
		II subjectId = livingSubjectId.addNewValue();
		subjectId.setRoot("2.16.840.1.113883.4.1"); subjectId.setExtension("014193804");
		livingSubjectId.setSemanticsText("LivingSubject.id");
		/*
		<livingSubjectName>
        <value use="L">
            <given>Clark</given>
            <given>Micheal</given>
            <prefix>Dr.</prefix>
            <suffix>IV</suffix>
            <family>Kent</family>
        </value>
        <semanticsText>LivingSubject.name</semanticsText>
    	</livingSubjectName>
		*/
		PRPAMT201306UV02LivingSubjectName livingSubjectName = parameterList.addNewLivingSubjectName();
		EN subjectValue = livingSubjectName.addNewValue();
		List nameTypelist = new ArrayList(); nameTypelist.add("L");
		subjectValue.setUse(nameTypelist);
		String givenName1 = "OTTO"; String[] givenNameArray = new String[] {givenName1};
		subjectValue.setGivenArray(givenNameArray);
		String prefix="Dr."; String[] prefixArray = new String[] {prefix};
		subjectValue.setPrefixArray(prefixArray);
		String suffix="IV"; String[] suffixArray = new String[] {suffix};
		subjectValue.setSuffixArray(suffixArray);
		String familyName="Garg"; String[] familyNameArray = new String[] {familyName};
		subjectValue.setFamilyArray(familyNameArray);
		livingSubjectName.setSemanticsText("LivingSubject.name");
        /*
		<patientAddress>
        <value use="PHYS">
            <streetAddressLine>Street1</streetAddressLine>
            <streetAddressLine>Street2</streetAddressLine>
            <streetAddressLine>Street3</streetAddressLine>
            <streetAddressLine>Street4</streetAddressLine>
            <city>Miami</city>
            <state>FL</state>
            <postalCode>33123</postalCode>
            <country>USA</country>
        </value>
        <semanticsText />
    	</patientAddress>
		*/
		PRPAMT201306UV02PatientAddress patientAddress = parameterList.addNewPatientAddress();
		AD patientAddressValue = patientAddress.addNewValue();
		List addrlist = new ArrayList(); addrlist.add("PHYS");
		patientAddressValue.setUse(addrlist);
		String streetAddressLine1="88 TRAIN ST";
		//String streetAddressLine2="Street1";
		String[] streetAddressLineArray = new String[] {streetAddressLine1};
		patientAddressValue.setStreetAddressLineArray(streetAddressLineArray);
		String addressCity = "DORCHESTER"; String[] addressCityArray = new String[] {addressCity};
		patientAddressValue.setCityArray(addressCityArray);
		String addressState = "MA"; String[] addressStateArray = new String[] {addressState};
		patientAddressValue.setStateArray(addressStateArray);
		String addressPostalCode = "02122"; String[] addressPostalCodeArray = new String[] {addressPostalCode};
		patientAddressValue.setPostalCodeArray(addressPostalCodeArray);
		String addressCountry = "USA"; String[] addressCountryArray = new String[] {addressCountry};
		patientAddressValue.setCountryArray(addressCountryArray);

		patientAddress.setSemanticsText("LivingSubject.patientAddress");

		//Printing the Request XML For fine output
		XmlOptions options = new XmlOptions();
        options.put( XmlOptions.LOAD_LINE_NUMBERS );
        options.setSavePrettyPrint();
        options.setSavePrettyPrintIndent(4);
        if(LOG.isDebugEnabled())
        	LOG.debug("\n" +root1305Doc.xmlText(options));

        // TEST the validity of an XML
        ArrayList validationErrors = new ArrayList();
        options.setErrorListener(validationErrors);

        boolean valid =root1305Doc.validate(options);
        if(valid){
        	if(LOG.isDebugEnabled())
				LOG.debug("Its valid 1305 Search Request xml");
        }
        else{
        	if(LOG.isDebugEnabled())
				LOG.debug("Not a valid xml file");
          Iterator itr = validationErrors.iterator();
    	  if(LOG.isDebugEnabled()) {
	          while(itr.hasNext()){
	  			LOG.debug(itr.next().toString());
	          }
    	  }
        }
      return root1305Doc.xmlText();

	}

}
